import Foundation
import SwiftUI

/// Main view model for LifeClock Watch App
@MainActor
class LifeClockViewModel: ObservableObject {
    @Published var currentPrediction: LifePrediction?
    @Published var healthData: HealthData?
    @Published var isLoading = false
    
    private let healthKitService = HealthKitService()
    
    /// Initialize health services and load data
    func initialize() async {
        isLoading = true
        defer { isLoading = false }
        
        do {
            try await healthKitService.requestAuthorization()
            await loadHealthData()
        } catch {
            print("Error initializing LifeClock: \(error)")
        }
    }
    
    /// Load current health data
    func loadHealthData() async {
        do {
            healthData = try await healthKitService.fetchHealthData()
        } catch {
            print("Error loading health data: \(error)")
        }
    }
    
    /// Generate life prediction based on current health data
    func generatePrediction() async {
        // Implementation for life prediction generation
        currentPrediction = LifePrediction(
            predictedLifespan: 75.0,
            remainingYears: 30.0,
            ageAtPrediction: 45.0,
            confidenceScore: 0.75
        )
    }
}